/********************************************************************************************************
*
* fiqDispatch.c
* Author         : A0406448
* Date           : 14/11/2014
*/
/* Copyright (C) 2013-2019 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*---------------------------------------------------------------------------------------------------------------------
* Revision History
*---------------------------------------------------------------------------------------------------------------------
* Version          Date        Author         Description
*---------------------------------------------------------------------------------------------------------------------
* 00.00.00       14/11/2014    A0406448        1. Initial Version
* 00.00.01       24/09/2024    Jagadish G      1. Added license information
***********************************************************************************************************/


#include "sys_common.h"
#include "sys_vim.h"

extern void fiqDispatch(void);

const t_isrFuncPTR ISR_TABLE[VIM_CHANNELS + 1] =
{
    &phantomInterrupt,
    &esmHighInterrupt,            /* Channel 0 */
    &phantomInterrupt,            /* Channel 1 */
    &phantomInterrupt,            /* Channel 2 */
    &phantomInterrupt,            /* Channel 3 */
    &phantomInterrupt,            /* Channel 4 */
    &phantomInterrupt,            /* Channel 5 */
    &phantomInterrupt,            /* Channel 6 */
    &phantomInterrupt,            /* Channel 7 */
    &phantomInterrupt,            /* Channel 8 */
    &phantomInterrupt,            /* Channel 9 */
    &phantomInterrupt,            /* Channel 10 */
    &phantomInterrupt,            /* Channel 11 */
    &phantomInterrupt,            /* Channel 12 */
    &phantomInterrupt,            /* Channel 13 */
    &phantomInterrupt,            /* Channel 14 */
    &phantomInterrupt,            /* Channel 15 */
    &phantomInterrupt,            /* Channel 16 */
    &phantomInterrupt,            /* Channel 17 */
    &phantomInterrupt,            /* Channel 18 */
    &phantomInterrupt,            /* Channel 19 */
    &phantomInterrupt,            /* Channel 20 */
    &phantomInterrupt,            /* Channel 21 */
    &phantomInterrupt,            /* Channel 22 */
    &phantomInterrupt,            /* Channel 23 */
    &phantomInterrupt,            /* Channel 24 */
    &phantomInterrupt,            /* Channel 25 */
    &phantomInterrupt,            /* Channel 26 */
    &phantomInterrupt,            /* Channel 27 */
    &phantomInterrupt,            /* Channel 28 */
    &phantomInterrupt,            /* Channel 29 */
    &phantomInterrupt,            /* Channel 30 */
    &phantomInterrupt,            /* Channel 31 */
    &phantomInterrupt,            /* Channel 32 */
    &phantomInterrupt,            /* Channel 33 */
    &phantomInterrupt,            /* Channel 34 */
    &phantomInterrupt,            /* Channel 35 */
    &phantomInterrupt,            /* Channel 36 */
    &phantomInterrupt,            /* Channel 37 */
    &phantomInterrupt,            /* Channel 38 */
    &phantomInterrupt,            /* Channel 39 */
    &phantomInterrupt,            /* Channel 40 */
    &phantomInterrupt,            /* Channel 41 */
    &phantomInterrupt,            /* Channel 42 */
    &phantomInterrupt,            /* Channel 43 */
    &phantomInterrupt,            /* Channel 44 */
    &phantomInterrupt,            /* Channel 45 */
    &phantomInterrupt,            /* Channel 46 */
    &phantomInterrupt,            /* Channel 47 */
    &phantomInterrupt,            /* Channel 48 */
    &phantomInterrupt,            /* Channel 49 */
    &phantomInterrupt,            /* Channel 50 */
    &phantomInterrupt,            /* Channel 51 */
    &phantomInterrupt,            /* Channel 52 */
    &phantomInterrupt,            /* Channel 53 */
    &phantomInterrupt,            /* Channel 54 */
    &phantomInterrupt,            /* Channel 55 */
    &phantomInterrupt,            /* Channel 56 */
    &phantomInterrupt,            /* Channel 57 */
    &phantomInterrupt,            /* Channel 58 */
    &phantomInterrupt,            /* Channel 59 */
    &phantomInterrupt,            /* Channel 60 */
    &phantomInterrupt,            /* Channel 61 */
    &phantomInterrupt,            /* Channel 62 */
    &phantomInterrupt,            /* Channel 63 */
    &phantomInterrupt,            /* Channel 64 */
    &phantomInterrupt,            /* Channel 65 */
    &phantomInterrupt,            /* Channel 66 */
    &phantomInterrupt,            /* Channel 67 */
    &phantomInterrupt,            /* Channel 68 */
    &phantomInterrupt,            /* Channel 69 */
    &phantomInterrupt,            /* Channel 70 */
    &phantomInterrupt,            /* Channel 71 */
    &phantomInterrupt,            /* Channel 72 */
    &phantomInterrupt,            /* Channel 73 */
    &phantomInterrupt,            /* Channel 74 */
    &phantomInterrupt,            /* Channel 75 */
    &phantomInterrupt,            /* Channel 76 */
    &phantomInterrupt,            /* Channel 77 */
    &phantomInterrupt,            /* Channel 78 */
    &phantomInterrupt,            /* Channel 79 */
    &phantomInterrupt,            /* Channel 80 */
    &phantomInterrupt,            /* Channel 81 */
    &phantomInterrupt,            /* Channel 82 */
    &phantomInterrupt,            /* Channel 83 */
    &phantomInterrupt,            /* Channel 84 */
    &phantomInterrupt,            /* Channel 85 */
    &phantomInterrupt,            /* Channel 86 */
    &phantomInterrupt,            /* Channel 87 */
    &phantomInterrupt,            /* Channel 88 */
    &phantomInterrupt,            /* Channel 89 */
    &phantomInterrupt,            /* Channel 90 */
    &phantomInterrupt,            /* Channel 91 */
    &phantomInterrupt,            /* Channel 92 */
    &phantomInterrupt,            /* Channel 93 */
    &phantomInterrupt,            /* Channel 94 */
};



#pragma INTERRUPT(fiqDispatch, FIQ);
#pragma RETAIN(fiqDispatch);

void fiqDispatch(void)
{
    uint32_t u32FiqIndex = vimREG->FIQINDEX;

    if (0ul == u32FiqIndex)
    {
        /* TODO: Add Fault Handler for Phantom Interrupt */

        phantomInterrupt();
    }
    else if (VIM_CHANNELS < u32FiqIndex)
    {
        /* TODO: Add fault handler, as index has exeeded max interrupts. */

        phantomInterrupt();
    }
    else
    {
        t_isrFuncPTR fiq_func_pnt = ISR_TABLE[u32FiqIndex]; /* Read FIQ Interrupt Vector */

        (*fiq_func_pnt)(); /* Execute interrupt routine */
    }

    return;
}
